#ifndef __FIND_ERROR_H__
#define __FIND_ERROR_H__

/* Maximum size of the string */
#define MAX_STRING 256

/* These defines are used for parsing the Format Line 
For Example VC++ Compiler Error has the following format:
"$FILE$($LINE$) : $ERROR$: $MSG$"
$FILE$ and $LINE$ are required, the rest are optional
*/
#define kFileToken "$FILE$"
#define kLineToken "$LINE$"
#define kErrorToken "$ERROR$"
#define kMsgToken "$MSG$"
#define kTokenStringTerm "$"
#define kTokenCharTerm '$'

/* This structure contains the information about the error that is 
needed in order to open that file and go to that line number */
struct _tagDEBUG_INFO
{
	TCHAR szFileName[MAX_PATH]; /* File Path: Required */
	LONG nLine; /* Line Number: Required */
	TCHAR szErrorCode[MAX_STRING]; /* Error Code: Optional */
	TCHAR szErrorMsg[MAX_STRING]; /* Error Message: Optional */
};

typedef struct _tagDEBUG_INFO DEBUG_INFO;
typedef DEBUG_INFO* LDEBUG_INFO;

/* These defines are used for our generic error parser */
typedef enum
{
	FILEPATH_TOKEN,
	LINE_TOKEN,
	ERRORCODE_TOKEN,
	ERRORMSG_TOKEN,
	SEPARATOR_TOKEN
}TOKEN;

struct TOKEN_LIST
{
	TOKEN Token;
	TCHAR szValue[MAX_STRING];
	struct TOKEN_LIST* pNext;
	
};

typedef struct TOKEN_LIST* LTOKEN_LIST;

#ifdef __cplusplus
extern "C" {
#endif

/* This is the main function */
BOOL WINAPI OnFindError(HWND hWnd, LDEBUG_INFO pDebugInfo);
/* This function retrieves the line from the rich edit*/
BOOL WINAPI RetrieveLine(HWND hWnd, LPSTR lpszLine);
/* This function gets the format line from the app. */
BOOL WINAPI GetFormatLine(TCHAR* szValue);
/* This function parses the format line and returns a list of tokens */
BOOL WINAPI ParseFormatLine(LPCTSTR lpszLine, LTOKEN_LIST* pTokenList);
/* This function uses the token list to parse the line from the rich edit */
BOOL WINAPI ParseLine(LPCTSTR lpszLine, LTOKEN_LIST* pTokenList);
/* This function uses the token list to fill in the DebugInfo structure */
BOOL WINAPI FillInfo(LDEBUG_INFO pDebugInfo, LTOKEN_LIST* pTokenList);

/* Support functions */
/* This function returns the index of the substring or -1 from the string */
int WINAPI Find(LPCTSTR lpszString, LPCTSTR lpszSub);
/* This function adds values to the token list */
BOOL WINAPI AddTokenToList(TOKEN Token, TCHAR* szValue, LTOKEN_LIST* pTokenList);
/* This function creates the token */
LTOKEN_LIST WINAPI CreateToken(TOKEN token, TCHAR* szValue);
/* This function deletes the token list */
BOOL WINAPI DeleteTokenList(LTOKEN_LIST* pTokenList);

#ifdef __cplusplus
}
#endif

#endif /* __FIND_ERROR_H__ */

